/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portablegit.win32;

import com.aptana.portablegit.win32.PortableGitPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

class Extractor {
    private static final String ZIP_EXECUTABLE = "$os$/7za.exe";
    private static final String ARCHIVE_PATH = "$os$/PortableGit-1.7.3.1-preview20101002.7z";

    private Extractor() {
    }

    private static IPath getBundlePath(String path) {
        URL url = FileLocator.find((Bundle)PortableGitPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)path), null);
        if (url != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
                File file = new File(url.getPath());
                if (file.exists()) {
                    return Path.fromOSString((String)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                PortableGitPlugin.log(e);
            }
        }
        return null;
    }

    public static boolean extract(IPath destination) {
        IPath zipExecutable = Extractor.getBundlePath(ZIP_EXECUTABLE);
        IPath archivePath = Extractor.getBundlePath(ARCHIVE_PATH);
        if (zipExecutable == null || archivePath == null) {
            PortableGitPlugin.log("Something is missing here.");
            return false;
        }
        File destinationFile = destination.toFile();
        if (!destinationFile.exists() && !destinationFile.mkdirs()) {
            PortableGitPlugin.log("Failed to create destination directory " + destinationFile.getAbsolutePath());
            return false;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(zipExecutable.toOSString(), "x", "-o" + destination.lastSegment(), "-y", archivePath.toOSString());
        processBuilder.directory(destinationFile.getParentFile());
        processBuilder.redirectErrorStream(true);
        StringBuffer output = new StringBuffer();
        try {
            String line;
            Process process = processBuilder.start();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
            process.waitFor();
            boolean bl = process.exitValue() == 0;
            return bl;
        }
        catch (IOException e) {
            PortableGitPlugin.log(e);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        finally {
            PortableGitPlugin.log(output.toString());
        }
    }
}

